/**
 * \file: mspin_connection_adapter_iap2.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN Connection Adapter iAP2
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_CONNECTION_ADAPTER_IAP2_H_
#define MSPIN_CONNECTION_ADAPTER_IAP2_H_

/**
 * @func MSPIN_setupConnection
 *
 * Opens devices for reading/writing and starts the reader thread
 *
 * @param pReadDeviceName The device name for reading data
 * @param pWriteDeviceName The device name for writing data
 * @return MSPIN_SUCCESS on success, otherwise MSPIN_ERROR_GENERAL
 */
MSPIN_ERROR mspin_conn_iap2_setupNativeTransportConnection(const char *pReadDeviceName, const char *pWriteDeviceName);

/**
 * @func MSPIN_shutdownConnection
 *
 * Cancels the iAP2 EA native transport reader thread, clears used resources and closes devices
 */
void mspin_conn_iap2_shutdownConnection(void);

/**
 * @func MSPIN_iAP2Send
 *
 * Writes data
 *
 * @param buffer The data to be written
 * @param bufferLen The size of the data to be written
 *
 * @return The number of bytes written if > 0. Otherwise the error code
 */
S32 mspin_conn_iap2_send(const U8* buffer, U32 bufferLen);

/**
 * @func MSPIN_iAP2Receive
 *
 * Read data (this is a blocking call).
 * If data is already there, it should return immediately. Otherwise it will block till data
 * arrives
 *
 * @param buffer The read buffer
 * @param bufferLen The max size of the read buffer
 * @param timeout U32 timeout in ms
 *
 * @return The bytes read if null or positive. Otherwise it indicates an error
 */
S32 mspin_conn_iap2_receive(U8* buffer, U32 bufferLen, U32 timeout);

#endif /* MSPIN_CONNECTION_ADAPTER_IAP2_H_ */
